package gov.va.med.mhv.integration.phr.service.via;

import gov.va.med.mhv.via.client.QueryBean;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.ObjectMapper;

public class ViaQueryBeanCache {

	private static Map<String,QueryBean> cacheBn = new HashMap<String,QueryBean>();
	private static Map<String,Date> cacheDt = new HashMap<String,Date>();
	private static final int EXPIRE = 330; //seconds (400-30 second lag)
	private static String directory="/tmp";
	private static boolean PERSIST = false;
	
	static {
		PERSIST = Boolean.parseBoolean(System.getProperty("QueryBeanPersist", "False"));
		try {
			if( PERSIST ) {
				ViaQueryBeanCache.init();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public ViaQueryBeanCache() {
	}
	
	public static void init() throws Exception {
        File file = new File(directory);
        File files[] = file.listFiles();
		for (File f : files) {
			if( !f.getName().matches("via_[0-9]+.json") ) {
				continue;
			}
			QueryBean qb = load(f);
			cacheBn.put(qb.getProvider().getLoginSiteCode(), qb);
			cacheDt.put(qb.getProvider().getLoginSiteCode(), new Date(f.lastModified()));
			System.out.println("Loaded " + qb.getProvider().getLoginSiteCode());
		}
	}
	
	public static QueryBean load(File f) throws Exception {
		ObjectMapper mapper = new ObjectMapper();
		mapper.setSerializationInclusion(Include.NON_EMPTY);
		QueryBean clone = null;
        try {
			clone = mapper.readValue(new FileInputStream(f), QueryBean.class);
		} catch (IOException e) {
			throw new ViaCloneException(e.getMessage());
		}
		return clone;
	}
	
	public static void save(QueryBean qb) throws Exception {
		File f = new File(directory+File.separator+"via_"+qb.getProvider().getLoginSiteCode()+".json");
		ObjectMapper mapper = new ObjectMapper();
		mapper.setSerializationInclusion(Include.NON_EMPTY);
        try {
        	mapper.writeValue(new FileOutputStream(f), qb);
		} catch (IOException e) {
			throw new ViaCloneException(e.getMessage());
		}
	}
	
	public static QueryBean clone(QueryBean t) throws ViaCloneException {
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		ObjectMapper mapper = new ObjectMapper();
		mapper.setSerializationInclusion(Include.NON_EMPTY);
		QueryBean clone = null;
        try {
			mapper.writeValue(bos, t);
			clone = mapper.readValue(bos.toByteArray(), QueryBean.class);
		} catch (IOException e) {
			throw new ViaCloneException(e.getMessage());
		}
		return clone;
	}
	
	protected static QueryBean fetch( String station ) throws ViaExpiredBeanException, ViaCloneException {
		if( cacheDt.containsKey(station) ) {
			//Check Date
			if( expired(cacheDt.get(station)) ) {
				throw new ViaExpiredBeanException("Bean for " + station + " is expired");
			} else {
				return clone(cacheBn.get(station));
			}
		} else {
			throw new ViaExpiredBeanException("No bean found");
		}
	}
	
	synchronized protected static QueryBean set( String station, QueryBean bean ) {
		cacheDt.put(station,new Date( System.currentTimeMillis() + (EXPIRE * 1000) ) );  //expires in the future
		cacheBn.put(station, bean);
		try {
			if( PERSIST ) {
				save(bean);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return bean;
	}
	
	private static boolean expired(Date expDate) {
		boolean result = true;
		Calendar exp = Calendar.getInstance();
		Calendar cur = Calendar.getInstance();
		exp.setTime(expDate);
		
		exp.add(Calendar.SECOND, EXPIRE); //Add seconds to the future when this will expire
		
		cur.setTime(new Date());
		if( cur.before(exp) ){
			result = false;
		}
		return result;
	}
}
